<?php
require_once __DIR__ . '/../inc/auth.php'; require_login(); if(!is_admin()){ echo 'Admins only'; exit; }
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
ensure_csrf();

if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['create'])){
    $hash=password_hash($_POST['password'], PASSWORD_BCRYPT);
    $pdo->prepare("INSERT INTO users (name,email,password_hash,role) VALUES (?,?,?,?)")->execute([$_POST['name'],$_POST['email'],$hash,$_POST['role']]);
  } elseif(isset($_POST['delete'])){
    $pdo->prepare("DELETE FROM users WHERE id=?")->execute([(int)$_POST['id']]);
  } elseif(isset($_POST['update'])){
    $hash = !empty($_POST['password']) ? password_hash($_POST['password'], PASSWORD_BCRYPT) : null;
    if($hash){
      $pdo->prepare("UPDATE users SET name=?, email=?, role=?, password_hash=? WHERE id=?")->execute([$_POST['name'],$_POST['email'],$_POST['role'],$hash,(int)$_POST['id']]);
    } else {
      $pdo->prepare("UPDATE users SET name=?, email=?, role=? WHERE id=?")->execute([$_POST['name'],$_POST['email'],$_POST['role'],(int)$_POST['id']]);
    }
  }
}
$rows=$pdo->query("SELECT id,name,email,role FROM users ORDER BY id DESC")->fetchAll();
?>
<h2>Users & Roles</h2>
<form method="post" class="grid">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="card"><label>Name</label><input name="name" required></div>
  <div class="card"><label>Email</label><input name="email" type="email" required></div>
  <div class="card"><label>Password</label><input name="password" type="password" required></div>
  <div class="card"><label>Role</label><select name="role"><option value="admin">admin</option><option value="caretaker">caretaker</option></select></div>
  <div class="card"><label>&nbsp;</label><button class="btn primary" name="create">Add User</button></div>
</form>
<table>
  <tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Actions</th></tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?= e($r['id']) ?></td><td><?= e($r['name']) ?></td><td><?= e($r['email']) ?></td><td><?= e($r['role']) ?></td>
    <td>
      <form method="post" style="display:inline-block">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <input type="hidden" name="id" value="<?= e($r['id']) ?>">
        <input type="hidden" name="name" value="<?= e($r['name']) ?>">
        <input type="hidden" name="email" value="<?= e($r['email']) ?>">
        <input type="hidden" name="role" value="<?= e($r['role']) ?>">
        <button class="btn" onclick="return editUser(this)">Edit</button>
      </form>
      <form method="post" style="display:inline-block" onsubmit="return confirm('Delete user?')">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="<?= e($r['id']) ?>"><button class="btn" name="delete">Delete</button>
      </form>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<script>
function editUser(btn){
  const f=btn.closest('form'); const id=f.querySelector('[name=id]').value;
  const name=f.querySelector('[name=name]').value; const email=f.querySelector('[name=email]').value; const role=f.querySelector('[name=role]').value;
  btn.closest('tr').outerHTML = `<tr>
    <td>${id}</td>
    <td><form method="post"><input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="${id}"><input name="name" value="${name}"></td>
    <td><input name="email" value="${email}"></td>
    <td><select name="role"><option value="admin" ${role==='admin'?'selected':''}>admin</option><option value="caretaker" ${role==='caretaker'?'selected':''}>caretaker</option></select></td>
    <td><input name="password" type="password" placeholder="(leave blank)"><button class="btn primary" name="update">Save</button></form></td>
  </tr>`; return false;
}
</script>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
