<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../inc/helpers.php';

$tenant_id = (int)($_GET['tenant_id'] ?? 0);
$st = $pdo->prepare("SELECT t.*, p.name AS property_name FROM tenants t LEFT JOIN properties p ON p.id=t.property_id WHERE t.id=?");
$st->execute([$tenant_id]); $tenant=$st->fetch();
if(!$tenant){ echo 'Tenant not found'; require_once __DIR__ . '/../partials/footer.php'; exit; }

$tx=[];
$inv = $pdo->prepare("SELECT id, issue_date AS d, amount_due FROM invoices WHERE tenant_id=? ORDER BY id ASC");
$inv->execute([$tenant_id]); foreach($inv as $i){ $tx[] = ['date'=>$i['d'],'type'=>'Invoice #'.$i['id'],'debit'=>$i['amount_due'],'credit'=>0]; }
$pay = $pdo->prepare("SELECT id, paid_at AS d, amount FROM payments WHERE invoice_id IN (SELECT id FROM invoices WHERE tenant_id=?) ORDER BY id ASC");
$pay->execute([$tenant_id]); foreach($pay as $p){ $tx[] = ['date'=>substr($p['d'],0,10),'type'=>'Payment #'.$p['id'],'debit'=>0,'credit'=>$p['amount']]; }
usort($tx, fn($a,$b)=>strcmp($a['date'],$b['date']));
$balance=0;
?>
<h2>Statement — <?= e($tenant['name']) ?> (<?= e($tenant['property_name']) ?>, Unit <?= e($tenant['unit']) ?>)</h2>
<table>
  <tr><th>Date</th><th>Description</th><th>Debit</th><th>Credit</th><th>Balance</th></tr>
  <?php foreach($tx as $t): $balance += $t['debit'] - $t['credit']; ?>
  <tr>
    <td><?= e($t['date']) ?></td>
    <td><?= e($t['type']) ?></td>
    <td><?= $t['debit'] ? number_format($t['debit'],2): '' ?></td>
    <td><?= $t['credit'] ? number_format($t['credit'],2): '' ?></td>
    <td><?= number_format($balance,2) ?></td>
  </tr>
  <?php endforeach; ?>
</table>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
