<?php
require_once __DIR__ . '/../inc/auth.php'; require_login();
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
ensure_csrf();
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(isset($_POST['record'])){
    if(strtolower($_POST['method'])==='m-pesa' && trim($_POST['ref'])===''){ echo "<div class='pill' style='background:#fee2e2;color:#b91c1c'>M-Pesa reference required</div>"; }
    else {
      $pdo->prepare("INSERT INTO payments (invoice_id, amount, paid_at, method, ref) VALUES (?,?,?,?,?)")
          ->execute([(int)$_POST['invoice_id'], (float)$_POST['amount'], $_POST['paid_at'], $_POST['method'], $_POST['ref']]);
      $pdo->prepare("UPDATE invoices SET amount_paid = amount_paid + ?, status = CASE WHEN amount_paid + ? >= amount_due THEN 'paid' ELSE 'partial' END WHERE id=?")
          ->execute([(float)$_POST['amount'], (float)$_POST['amount'], (int)$_POST['invoice_id']]);
    }
  } elseif(isset($_POST['delete']) && is_admin()){
    $pdo->prepare("DELETE FROM payments WHERE id=?")->execute([(int)$_POST['id']]);
  }
}
$invoices = $pdo->query("SELECT i.id, t.name tenant_name, i.amount_due, i.amount_paid FROM invoices i LEFT JOIN tenants t ON t.id=i.tenant_id ORDER BY i.id DESC")->fetchAll();
$rows = $pdo->query("SELECT pay.*, t.name AS tenant_name FROM payments pay LEFT JOIN invoices i ON i.id=pay.invoice_id LEFT JOIN tenants t ON t.id=i.tenant_id ORDER BY pay.id DESC")->fetchAll();
?>
<h2>Payments</h2>
<form class="grid" method="post">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="card"><label>Invoice</label><select name="invoice_id"><?php foreach($invoices as $i): ?><option value="<?= e($i['id']) ?>">#<?= e($i['id']) ?> • <?= e($i['tenant_name']) ?> • Due: <?= number_format($i['amount_due']-$i['amount_paid'],2) ?></option><?php endforeach; ?></select></div>
  <div class="card"><label>Amount (KES)</label><input name="amount" type="number" step="0.01" required></div>
  <div class="card"><label>Paid At</label><input name="paid_at" type="datetime-local" value="<?= date('Y-m-d\TH:i') ?>"></div>
  <div class="card"><label>Method</label><select name="method"><option>Cash</option><option>Bank</option><option>M-Pesa</option></select></div>
  <div class="card"><label>Reference</label><input name="ref" placeholder="Tx code (required for M-Pesa)"></div>
  <div class="card"><label>&nbsp;</label><button class="btn primary" name="record">Record Payment</button></div>
</form>
<div class="searchrow"><a class="btn" href="export_payments.php">Export CSV</a></div>
<table>
  <tr><th>#</th><th>Tenant</th><th>Invoice</th><th>Amount</th><th>Paid At</th><th>Method</th><th>Ref</th><th>Actions</th></tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?= e($r['id']) ?></td>
    <td><?= e($r['tenant_name']) ?></td>
    <td>#<?= e($r['invoice_id']) ?></td>
    <td><?= number_format($r['amount'],2) ?></td>
    <td><?= e($r['paid_at']) ?></td>
    <td><?= e($r['method']) ?></td>
    <td><?= e($r['ref']) ?></td>
    <td><a class="btn" href="receipt.php?id=<?= e($r['id']) ?>">Receipt</a><?php if(is_admin()): ?><form method="post" style="display:inline-block" onsubmit="return confirm('Delete payment?')"><input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>"><input type="hidden" name="id" value="<?= e($r['id']) ?>"><button class="btn" name="delete">Delete</button></form><?php endif; ?></td>
  </tr>
  <?php endforeach; ?>
</table>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
