<?php
require_once __DIR__ . '/../inc/auth.php'; require_login(); if(!is_admin()){ echo 'Admins only'; exit; }
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../inc/helpers.php';
ensure_csrf();
$msg='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $csv = trim($_POST['csv'] ?? '');
  $rows = array_map('str_getcsv', preg_split("/\r?\n/", $csv));
  $count=0;
  foreach($rows as $r){
    if(count($r) < 6) continue;
    [$name,$email,$phone,$property_id,$unit,$monthly_rent] = $r;
    if(!$name) continue;
    $stmt=$pdo->prepare("INSERT INTO tenants (name,email,phone,property_id,unit,monthly_rent) VALUES (?,?,?,?,?,?)");
    $stmt->execute([$name,$email,$phone,(int)$property_id,$unit,(float)$monthly_rent]);
    $count++;
  }
  $msg="Imported $count tenants.";
}
?>
<h2>Import Tenants (CSV)</h2>
<?php if($msg): ?><div class="pill"><?= e($msg) ?></div><?php endif; ?>
<p class="muted">Paste CSV rows with columns: name,email,phone,property_id,unit,monthly_rent</p>
<form method="post">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <textarea name="csv" rows="10" style="width:100%"></textarea>
  <p><button class="btn primary">Import</button></p>
</form>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
