<?php
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../config/config.php';
$u = current_user();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= e(APP_NAME) ?></title>
<style>
  :root{--brand:#0ea5e9}
  body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7fb}
  header{background:var(--brand);color:#fff;padding:12px 16px;display:flex;align-items:center;justify-content:space-between}
  nav a{color:#fff;text-decoration:none;margin-right:12px;font-weight:600}
  .wrap{max-width:1100px;margin:18px auto;background:#fff;padding:16px;border-radius:12px;box-shadow:0 2px 12px rgba(0,0,0,.06)}
  table{width:100%;border-collapse:collapse}
  th,td{padding:8px;border-bottom:1px solid #f0f0f0}
  th{background:#f9fafb}
  .btn{padding:6px 10px;border-radius:8px;border:1px solid #e2e8f0;background:#fff;cursor:pointer}
  .btn.primary{background:var(--brand);color:#fff;border:none}
  input,select,textarea{width:100%;padding:8px;border:1px solid #e2e8f0;border-radius:8px;box-sizing:border-box}
  .grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(240px,1fr));gap:12px}
  .card{padding:14px;background:#fff;border:1px solid #edf2f7;border-radius:12px}
  .muted{color:#6b7280;font-size:13px}
  .pill{display:inline-block;padding:3px 8px;border-radius:999px;background:#f1f5f9}
  .searchrow{display:flex;gap:8px;align-items:center;margin:8px 0}
</style>
</head>
<body>
<header>
  <div><strong><?= e(APP_NAME) ?></strong> <span class="muted">• Rent Collection</span></div>
  <nav>
    <?php if($u): ?>
      <a href="dashboard.php">Dashboard</a>
      <a href="properties.php">Properties</a>
      <a href="units.php">Units</a>
      <a href="tenants.php">Tenants</a>
      <a href="invoices.php">Invoices</a>
      <a href="payments.php">Payments</a>
      <?php if(is_admin()): ?>
        <a href="users.php">Users</a>
        <a href="settings.php">Settings</a>
        <a href="invoices_bulk.php">Auto-Generate</a>
        <a href="templates.php">Email/SMS</a>
      <?php endif; ?>
      <a href="profile.php">My Profile</a>
      <a href="logout.php">Logout</a>
    <?php else: ?>
      <a href="login.php">Login</a>
    <?php endif; ?>
  </nav>
</header>
<div class="wrap">
